/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Group;
import org.ovirt.engine.sdk.decorators.GroupTag;
import org.ovirt.engine.sdk.entities.Tag;
import org.ovirt.engine.sdk.entities.Tags;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class GroupTags
extends CollectionDecorator<Tag, Tags, GroupTag> {
    private Group parent;

    public GroupTags(HttpProxyBroker proxy, Group parent) {
        super(proxy, "tags");
        this.parent = parent;
    }

    @Override
    public List<GroupTag> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Tags.class, GroupTag.class);
    }

    @Override
    public GroupTag get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Tag.class, GroupTag.class);
    }

    public List<GroupTag> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Tags.class, GroupTag.class, headers);
    }

    public GroupTag add(Tag tag) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, tag, Tag.class, GroupTag.class, headers);
    }

    public GroupTag add(Tag tag, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().add("Expect", expect).add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, tag, Tag.class, GroupTag.class, headers);
    }
}

