/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.StorageDomain;
import org.ovirt.engine.sdk.decorators.StorageDomainTemplate;
import org.ovirt.engine.sdk.entities.Template;
import org.ovirt.engine.sdk.entities.Templates;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class StorageDomainTemplates
extends CollectionDecorator<Template, Templates, StorageDomainTemplate> {
    private StorageDomain parent;

    public StorageDomainTemplates(HttpProxyBroker proxy, StorageDomain parent) {
        super(proxy, "templates");
        this.parent = parent;
    }

    @Override
    public List<StorageDomainTemplate> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Templates.class, StorageDomainTemplate.class);
    }

    @Override
    public StorageDomainTemplate get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Template.class, StorageDomainTemplate.class);
    }

    public List<StorageDomainTemplate> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Templates.class, StorageDomainTemplate.class, headers);
    }
}

