/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.VMDisk;
import org.ovirt.engine.sdk.decorators.VMDiskPermission;
import org.ovirt.engine.sdk.entities.Permission;
import org.ovirt.engine.sdk.entities.Permissions;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class VMDiskPermissions
extends CollectionDecorator<Permission, Permissions, VMDiskPermission> {
    private VMDisk parent;

    public VMDiskPermissions(HttpProxyBroker proxy, VMDisk parent) {
        super(proxy, "permissions");
        this.parent = parent;
    }

    @Override
    public List<VMDiskPermission> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Permissions.class, VMDiskPermission.class);
    }

    @Override
    public VMDiskPermission get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Permission.class, VMDiskPermission.class);
    }

    public VMDiskPermission add(Permission permission) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, permission, Permission.class, VMDiskPermission.class, headers);
    }
}

