/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.VMNICReportedDevices;
import org.ovirt.engine.sdk.decorators.VMNICStatistics;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.NIC;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class VMNIC
extends NIC {
    private HttpProxyBroker proxy;
    private VMNICReportedDevices vMNICReportedDevices;
    private VMNICStatistics vMNICStatistics;

    public VMNIC(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    @Override
    public synchronized VMNICReportedDevices getReportedDevices() {
        if (this.vMNICReportedDevices == null) {
            this.vMNICReportedDevices = new VMNICReportedDevices(this.proxy, this);
        }
        return this.vMNICReportedDevices;
    }

    @Override
    public synchronized VMNICStatistics getStatistics() {
        if (this.vMNICStatistics == null) {
            this.vMNICStatistics = new VMNICStatistics(this.proxy, this);
        }
        return this.vMNICStatistics;
    }

    public Action activate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/activate";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action activate(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/activate";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public VMNIC update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        return this.getProxy().update(url, this, NIC.class, VMNIC.class);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Action deactivate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/deactivate";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action deactivate(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/deactivate";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }
}

