/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.web;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderUtils;
import org.ovirt.engine.sdk.utils.HttpResponseHelper;
import org.ovirt.engine.sdk.web.ConnectionsPool;
import org.ovirt.engine.sdk.web.HttpDelete;

public class HttpProxy {
    private static final String CONTENT_TYPE_HEADER = "Content-type";
    private static final String PERSISTENT_AUTH_HEADER = "Prefer";
    private static final String FILTER_HEADER = "Filter";
    private static final String JSESSIONID = "JSESSIONID";
    private static int BAD_REQUEST = 400;
    private static String[] STATIC_HEADERS = new String[]{"Content-type:application/xml"};
    private ConnectionsPool pool;
    private List<Header> staticHeaders;
    private boolean persistentAuth = true;
    private boolean insecure = false;
    private boolean filter = false;
    private boolean debug = false;

    public HttpProxy(ConnectionsPool pool, boolean persistent_auth, boolean insecure, boolean filter, boolean debug) {
        this.pool = pool;
        this.staticHeaders = HttpHeaderUtils.toHeaders(STATIC_HEADERS);
        this.persistentAuth = persistent_auth;
        this.insecure = insecure;
        this.filter = filter;
        this.debug = debug;
    }

    public URL getUrl() {
        return this.pool.getUrl();
    }

    public String execute(HttpUriRequest request, List<Header> headers, Boolean last) throws IOException, ClientProtocolException, ServerException {
        this.injectHeaders(request, headers);
        HttpResponse response = this.pool.execute(request, (HttpContext)this.getContext());
        if (response.getStatusLine().getStatusCode() < BAD_REQUEST) {
            return HttpResponseHelper.getEntity(response.getEntity());
        }
        throw new ServerException(response);
    }

    public BasicHttpContext getContext() {
        BasicHttpContext context = new BasicHttpContext();
        if (this.persistentAuth) {
            context.setAttribute("http.cookie-store", (Object)this.pool.getCookieStore());
        }
        return context;
    }

    private void injectHeaders(HttpUriRequest request, List<Header> headers) {
        if (headers != null && !headers.isEmpty()) {
            request.setHeaders(headers.toArray(new Header[headers.size()]));
        }
        for (Header header : this.staticHeaders) {
            if (header.getName().equals(CONTENT_TYPE_HEADER) && (request instanceof HttpDelete && ((HttpDelete)request).getEntity() == null || request instanceof HttpPut && ((HttpPut)request).getEntity() == null || request instanceof HttpPost && ((HttpPost)request).getEntity() == null)) continue;
            request.addHeader(header);
        }
        request.addHeader(FILTER_HEADER, Boolean.toString(this.isFilter()));
        if (this.persistentAuth) {
            request.addHeader(PERSISTENT_AUTH_HEADER, "persistent-auth");
            String session = this.getJsession();
            if (session != null) {
                request.addHeader(JSESSIONID, session);
            }
        }
    }

    private String getJsession() {
        if (this.pool.getCookies() != null && !this.pool.getCookies().isEmpty()) {
            for (Cookie cookie : this.pool.getCookies()) {
                if (!cookie.getName().equals(JSESSIONID)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public boolean isPersistentAuth() {
        return this.persistentAuth;
    }

    public void setPersistentAuth(boolean persistentAuth) {
        this.persistentAuth = persistentAuth;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    public void setInsecure(boolean insecure) {
        this.insecure = insecure;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void shutdown() {
        this.pool.getConnectionManager().shutdown();
    }
}

