/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.DataCenterClusterGlusterVolumes;
import org.ovirt.engine.sdk.decorators.DataCenterClusterNetworks;
import org.ovirt.engine.sdk.decorators.DataCenterClusterPermissions;
import org.ovirt.engine.sdk.entities.Cluster;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class DataCenterCluster
extends Cluster {
    private HttpProxyBroker proxy;
    private DataCenterClusterPermissions dataCenterClusterPermissions;
    private DataCenterClusterGlusterVolumes dataCenterClusterGlusterVolumes;
    private DataCenterClusterNetworks dataCenterClusterNetworks;

    public DataCenterCluster(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    public synchronized DataCenterClusterPermissions getPermissions() {
        if (this.dataCenterClusterPermissions == null) {
            this.dataCenterClusterPermissions = new DataCenterClusterPermissions(this.proxy, this);
        }
        return this.dataCenterClusterPermissions;
    }

    public synchronized DataCenterClusterGlusterVolumes getGlusterVolumes() {
        if (this.dataCenterClusterGlusterVolumes == null) {
            this.dataCenterClusterGlusterVolumes = new DataCenterClusterGlusterVolumes(this.proxy, this);
        }
        return this.dataCenterClusterGlusterVolumes;
    }

    public synchronized DataCenterClusterNetworks getNetworks() {
        if (this.dataCenterClusterNetworks == null) {
            this.dataCenterClusterNetworks = new DataCenterClusterNetworks(this.proxy, this);
        }
        return this.dataCenterClusterNetworks;
    }

    public DataCenterCluster update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        return this.getProxy().update(url, this, Cluster.class, DataCenterCluster.class);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

