/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Disk;
import org.ovirt.engine.sdk.decorators.DiskStatistic;
import org.ovirt.engine.sdk.entities.Statistic;
import org.ovirt.engine.sdk.entities.Statistics;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class DiskStatistics
extends CollectionDecorator<Statistic, Statistics, DiskStatistic> {
    private Disk parent;

    public DiskStatistics(HttpProxyBroker proxy, Disk parent) {
        super(proxy, "statistics");
        this.parent = parent;
    }

    @Override
    public List<DiskStatistic> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Statistics.class, DiskStatistic.class);
    }

    @Override
    public DiskStatistic get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Statistic.class, DiskStatistic.class);
    }

    public List<DiskStatistic> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Statistics.class, DiskStatistic.class, headers);
    }
}

