/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.GroupPermissions;
import org.ovirt.engine.sdk.decorators.GroupRoles;
import org.ovirt.engine.sdk.decorators.GroupTags;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class Group
extends org.ovirt.engine.sdk.entities.Group {
    private HttpProxyBroker proxy;
    private GroupRoles groupRoles;
    private GroupPermissions groupPermissions;
    private GroupTags groupTags;

    public Group(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    @Override
    public synchronized GroupRoles getRoles() {
        if (this.groupRoles == null) {
            this.groupRoles = new GroupRoles(this.proxy, this);
        }
        return this.groupRoles;
    }

    public synchronized GroupPermissions getPermissions() {
        if (this.groupPermissions == null) {
            this.groupPermissions = new GroupPermissions(this.proxy, this);
        }
        return this.groupPermissions;
    }

    public synchronized GroupTags getTags() {
        if (this.groupTags == null) {
            this.groupTags = new GroupTags(this.proxy, this);
        }
        return this.groupTags;
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

