/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.VMSnapshotCdRoms;
import org.ovirt.engine.sdk.decorators.VMSnapshotDisks;
import org.ovirt.engine.sdk.decorators.VMSnapshotNics;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.entities.Snapshot;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class VMSnapshot
extends Snapshot {
    private HttpProxyBroker proxy;
    private VMSnapshotNics vMSnapshotNics;
    private VMSnapshotDisks vMSnapshotDisks;
    private VMSnapshotCdRoms vMSnapshotCdRoms;

    public VMSnapshot(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    @Override
    public synchronized VMSnapshotNics getNics() {
        if (this.vMSnapshotNics == null) {
            this.vMSnapshotNics = new VMSnapshotNics(this.proxy, this);
        }
        return this.vMSnapshotNics;
    }

    @Override
    public synchronized VMSnapshotDisks getDisks() {
        if (this.vMSnapshotDisks == null) {
            this.vMSnapshotDisks = new VMSnapshotDisks(this.proxy, this);
        }
        return this.vMSnapshotDisks;
    }

    @Override
    public synchronized VMSnapshotCdRoms getCdRoms() {
        if (this.vMSnapshotCdRoms == null) {
            this.vMSnapshotCdRoms = new VMSnapshotCdRoms(this.proxy, this);
        }
        return this.vMSnapshotCdRoms;
    }

    public Action preview(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/preview";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action preview(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/preview";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action undo(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/undo";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action undo(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/undo";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action commit(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/commit";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action commit(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/commit";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action restore(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/restore";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action restore(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/restore";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

