/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.HostHooks;
import org.ovirt.engine.sdk.decorators.HostNICs;
import org.ovirt.engine.sdk.decorators.HostPermissions;
import org.ovirt.engine.sdk.decorators.HostStatistics;
import org.ovirt.engine.sdk.decorators.HostTags;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class Host
extends org.ovirt.engine.sdk.entities.Host {
    private HttpProxyBroker proxy;
    private HostHooks hostHooks;
    private HostNICs hostNICs;
    private HostTags hostTags;
    private HostPermissions hostPermissions;
    private HostStatistics hostStatistics;

    public Host(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    @Override
    public synchronized HostHooks getHooks() {
        if (this.hostHooks == null) {
            this.hostHooks = new HostHooks(this.proxy, this);
        }
        return this.hostHooks;
    }

    public synchronized HostNICs getHostNics() {
        if (this.hostNICs == null) {
            this.hostNICs = new HostNICs(this.proxy, this);
        }
        return this.hostNICs;
    }

    public synchronized HostTags getTags() {
        if (this.hostTags == null) {
            this.hostTags = new HostTags(this.proxy, this);
        }
        return this.hostTags;
    }

    public synchronized HostPermissions getPermissions() {
        if (this.hostPermissions == null) {
            this.hostPermissions = new HostPermissions(this.proxy, this);
        }
        return this.hostPermissions;
    }

    @Override
    public synchronized HostStatistics getStatistics() {
        if (this.hostStatistics == null) {
            this.hostStatistics = new HostStatistics(this.proxy, this);
        }
        return this.hostStatistics;
    }

    public Action install(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/install";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action install(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/install";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action activate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/activate";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action activate(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/activate";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Host update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.Host.class, Host.class);
    }

    public Action fence(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/fence";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action fence(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/fence";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action iscsidiscover(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/iscsidiscover";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action iscsidiscover(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/iscsidiscover";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action approve(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/approve";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action approve(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/approve";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action iscsilogin(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/iscsilogin";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action iscsilogin(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/iscsilogin";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Action action, Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, action, Action.class, Response.class, headers);
    }

    public Action deactivate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/deactivate";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action deactivate(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/deactivate";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action commitnetconfig(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/commitnetconfig";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action commitnetconfig(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/commitnetconfig";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }
}

