/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.exceptions;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Fault;
import org.ovirt.engine.sdk.exceptions.OvirtSdkException;
import org.ovirt.engine.sdk.utils.HttpResponseHelper;
import org.ovirt.engine.sdk.utils.SerializationHelper;
import org.ovirt.engine.sdk.utils.StringUtils;

public class ServerException
extends OvirtSdkException {
    private static final long serialVersionUID = 3286777099419639787L;
    private static final String ACTION_FAULT = "<action>";
    private static final String FAULT = "<fault>";
    private int code;
    private String reason;
    private String detail;

    public ServerException(HttpResponse response) {
        super(response.getStatusLine().getReasonPhrase());
        this.code = this.getCode(response);
        this.reason = this.getReason(response);
        this.detail = this.getDetail(response.getEntity());
    }

    private int getCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    private String getReason(HttpResponse response) {
        return response.getStatusLine().getReasonPhrase();
    }

    private String getDetail(HttpEntity httpEentity) {
        String detail;
        block11: {
            detail = null;
            String entity = null;
            Fault fault = null;
            try {
                entity = HttpResponseHelper.getEntity(httpEentity);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (entity != null && !entity.equals("") && !entity.startsWith("<html>")) {
                try {
                    if (entity.contains(ACTION_FAULT)) {
                        fault = SerializationHelper.unmarshall(Action.class, entity).getFault();
                    } else if (entity.contains(FAULT)) {
                        fault = SerializationHelper.unmarshall(Fault.class, entity);
                    }
                    if (fault != null) {
                        detail = StringUtils.removeBrackets(fault.getDetail());
                        break block11;
                    }
                    detail = entity;
                }
                catch (Exception e) {
                    detail = entity;
                }
            } else {
                detail = entity;
            }
        }
        return detail;
    }

    public int getCode() {
        return this.code;
    }

    public String getReason() {
        return this.reason;
    }

    public String getDetail() {
        return this.detail;
    }

    @Override
    public String toString() {
        return "\ncode  : " + this.getCode() + "\nreason: " + this.getReason() + "\ndetail: " + this.getDetail();
    }
}

