/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ovirt.engine.sdk.entities.ObjectFactory;
import org.ovirt.engine.sdk.exceptions.MarshallingException;
import org.ovirt.engine.sdk.utils.StringUtils;

public class SerializationHelper {
    private static final Map<Class<?>, JAXBContextHolder> contexts = new HashMap();
    private static String PACKAGE_CONTEXT = "org.ovirt.engine.sdk.entities";
    private static JAXBContext JAXB_CONTEXT = null;
    private static ObjectFactory factory = new ObjectFactory();
    private static Map<String, Method> factoryMethods = new HashMap<String, Method>();

    private SerializationHelper() {
    }

    private static <S> String marshall(JAXBElement<S> element) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SerializationHelper.marshall(baos, element);
        return new String(baos.toByteArray());
    }

    public static <S> String marshall(Class<S> clz, S obj) {
        try {
            JAXBElement<S> element = SerializationHelper.getElement(clz, obj);
            if (element != null) {
                return SerializationHelper.marshall(element);
            }
            throw new MarshallingException("Coresponding JAXBElement for \"" + clz.getSimpleName() + "\" is not found.");
        }
        catch (JAXBException e) {
            throw new MarshallingException(e);
        }
    }

    private static <S> JAXBElement<S> getElement(Class<S> clz, S obj) {
        Method m = SerializationHelper.getCreateMethod(clz);
        if (m != null) {
            try {
                return (JAXBElement)m.invoke((Object)factory, obj);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static synchronized <S> Method getCreateMethod(Class<S> clz) {
        String createMethod = "create" + clz.getSimpleName();
        if (factoryMethods.isEmpty()) {
            for (Method m : factory.getClass().getMethods()) {
                if (m.getParameterTypes().length <= 0) continue;
                factoryMethods.put(m.getName(), m);
            }
        }
        if (factoryMethods.containsKey(createMethod)) {
            return factoryMethods.get(createMethod);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S> void marshall(OutputStream os, JAXBElement<S> element) throws JAXBException {
        Marshaller marshaller;
        Marshaller marshaller2 = marshaller = SerializationHelper.getContext(element.getDeclaredType()).getMarshaller();
        synchronized (marshaller2) {
            marshaller.marshal(element, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> S unmarshall(Class<S> clz, String xml) {
        if (StringUtils.isNulOrEmpty(xml)) {
            return null;
        }
        try {
            Unmarshaller unmarshaller;
            Unmarshaller unmarshaller2 = unmarshaller = SerializationHelper.getContext(clz).getUnmarshaller();
            synchronized (unmarshaller2) {
                JAXBElement root = unmarshaller.unmarshal((Source)new StreamSource(new StringReader(xml)), clz);
                return (S)root.getValue();
            }
        }
        catch (JAXBException e) {
            throw new MarshallingException(e);
        }
    }

    private static synchronized JAXBContextHolder getContext(Class<?> clz) throws JAXBException {
        if (JAXB_CONTEXT == null) {
            ClassLoader cl = ObjectFactory.class.getClassLoader();
            JAXB_CONTEXT = JAXBContext.newInstance((String)PACKAGE_CONTEXT, (ClassLoader)cl);
        }
        if (!contexts.containsKey(clz)) {
            contexts.put(clz, new JAXBContextHolder(JAXB_CONTEXT));
        }
        return contexts.get(clz);
    }

    private static class JAXBContextHolder {
        Unmarshaller unmarshaller;
        Marshaller marshaller;
        JAXBContext context;

        public JAXBContextHolder(JAXBContext context) {
            this.context = context;
        }

        public Unmarshaller getUnmarshaller() throws JAXBException {
            if (this.unmarshaller == null) {
                this.unmarshaller = this.context.createUnmarshaller();
            }
            return this.unmarshaller;
        }

        public Marshaller getMarshaller() throws JAXBException {
            if (this.marshaller == null) {
                this.marshaller = this.context.createMarshaller();
                this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            }
            return this.marshaller;
        }
    }
}

