/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.ClusterGlusterVolume;
import org.ovirt.engine.sdk.decorators.ClusterGlusterVolumeGlusterBrick;
import org.ovirt.engine.sdk.entities.GlusterBrick;
import org.ovirt.engine.sdk.entities.GlusterBricks;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class ClusterGlusterVolumeGlusterBricks
extends CollectionDecorator<GlusterBrick, GlusterBricks, ClusterGlusterVolumeGlusterBrick> {
    private ClusterGlusterVolume parent;

    public ClusterGlusterVolumeGlusterBricks(HttpProxyBroker proxy, ClusterGlusterVolume parent) {
        super(proxy, "bricks");
        this.parent = parent;
    }

    @Override
    public List<ClusterGlusterVolumeGlusterBrick> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, GlusterBricks.class, ClusterGlusterVolumeGlusterBrick.class);
    }

    @Override
    public ClusterGlusterVolumeGlusterBrick get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, GlusterBrick.class, ClusterGlusterVolumeGlusterBrick.class);
    }

    public List<ClusterGlusterVolumeGlusterBrick> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, GlusterBricks.class, ClusterGlusterVolumeGlusterBrick.class, headers);
    }

    public ClusterGlusterVolumeGlusterBrick add(GlusterBrick glusterbrick) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, glusterbrick, GlusterBrick.class, ClusterGlusterVolumeGlusterBrick.class, headers);
    }

    public ClusterGlusterVolumeGlusterBrick add(GlusterBrick glusterbrick, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().add("Expect", expect).add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, glusterbrick, GlusterBrick.class, ClusterGlusterVolumeGlusterBrick.class, headers);
    }
}

