/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk;

import java.io.IOException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.Clusters;
import org.ovirt.engine.sdk.decorators.DataCenters;
import org.ovirt.engine.sdk.decorators.Disks;
import org.ovirt.engine.sdk.decorators.Domains;
import org.ovirt.engine.sdk.decorators.Events;
import org.ovirt.engine.sdk.decorators.Groups;
import org.ovirt.engine.sdk.decorators.Hosts;
import org.ovirt.engine.sdk.decorators.Networks;
import org.ovirt.engine.sdk.decorators.Roles;
import org.ovirt.engine.sdk.decorators.StorageDomains;
import org.ovirt.engine.sdk.decorators.Tags;
import org.ovirt.engine.sdk.decorators.Templates;
import org.ovirt.engine.sdk.decorators.Users;
import org.ovirt.engine.sdk.decorators.VMs;
import org.ovirt.engine.sdk.decorators.VmPools;
import org.ovirt.engine.sdk.entities.API;
import org.ovirt.engine.sdk.entities.ApiSummary;
import org.ovirt.engine.sdk.entities.ProductInfo;
import org.ovirt.engine.sdk.entities.SpecialObjects;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.exceptions.UnsecuredConnectionAttemptError;
import org.ovirt.engine.sdk.utils.SerializationHelper;
import org.ovirt.engine.sdk.web.ConnectionsPool;
import org.ovirt.engine.sdk.web.ConnectionsPoolBuilder;
import org.ovirt.engine.sdk.web.HttpProxy;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.HttpProxyBuilder;

public class Api {
    private HttpProxyBroker proxy = null;
    private API entryPoint = null;
    private Networks networks;
    private Tags tags;
    private Users users;
    private Templates templates;
    private Events events;
    private Domains domains;
    private Disks disks;
    private Clusters clusters;
    private DataCenters dataCenters;
    private Roles roles;
    private Hosts hosts;
    private VMs vMs;
    private VmPools vmPools;
    private StorageDomains storageDomains;
    private Groups groups;

    public Api(String url, String username, String password) throws ClientProtocolException, ServerException, IOException, UnsecuredConnectionAttemptError {
        ConnectionsPool pool = new ConnectionsPoolBuilder(url, username, password).build();
        HttpProxy httpProxy = new HttpProxyBuilder(pool).build();
        this.proxy = new HttpProxyBroker(httpProxy);
        this.initResources();
    }

    public Api(String url, String sessionid) throws ClientProtocolException, ServerException, IOException, UnsecuredConnectionAttemptError {
        ConnectionsPool pool = new ConnectionsPoolBuilder(url).build();
        HttpProxy httpProxy = new HttpProxyBuilder(pool).sessionid(sessionid).persistentAuth(true).build();
        this.proxy = new HttpProxyBroker(httpProxy);
        this.initResources();
    }

    public Api(String url, String username, String password, boolean noHostVerification) throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        ConnectionsPool pool = new ConnectionsPoolBuilder(url, username, password).noHostVerification(noHostVerification).build();
        HttpProxy httpProxy = new HttpProxyBuilder(pool).build();
        this.proxy = new HttpProxyBroker(httpProxy);
        this.initResources();
    }

    public Api(String url, String sessionid, boolean noHostVerification) throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        ConnectionsPool pool = new ConnectionsPoolBuilder(url).noHostVerification(noHostVerification).build();
        HttpProxy httpProxy = new HttpProxyBuilder(pool).sessionid(sessionid).persistentAuth(true).build();
        this.proxy = new HttpProxyBroker(httpProxy);
        this.initResources();
    }

    public Api(String url, String username, String password, Boolean noHostVerification, Boolean filter) throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        ConnectionsPool pool = new ConnectionsPoolBuilder(url, username, password).noHostVerification(noHostVerification).build();
        HttpProxy httpProxy = new HttpProxyBuilder(pool).filter(filter).build();
        this.proxy = new HttpProxyBroker(httpProxy);
        this.initResources();
    }

    public Api(String url, String username, String password, String sessionid, Integer port, Integer timeout, Boolean persistentAuth, Boolean noHostVerification, Boolean filter, Boolean debug) throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        ConnectionsPool pool = new ConnectionsPoolBuilder(url, username, password).port(port).timeout(timeout).noHostVerification(noHostVerification).build();
        HttpProxy httpProxy = new HttpProxyBuilder(pool).sessionid(sessionid).persistentAuth(persistentAuth).filter(filter).debug(debug).build();
        this.proxy = new HttpProxyBroker(httpProxy);
        this.initResources();
    }

    private API getEntryPoint() throws ClientProtocolException, ServerException, IOException, UnsecuredConnectionAttemptError {
        String entryPointXML = this.proxy.get(this.proxy.getRoot());
        if (entryPointXML != null && !entryPointXML.equals("")) {
            return SerializationHelper.unmarshall(API.class, entryPointXML);
        }
        throw new UnsecuredConnectionAttemptError();
    }

    private void initResources() throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        this.entryPoint = this.getEntryPoint();
    }

    public void setFilter(boolean filter) {
        this.proxy.setFilter(filter);
    }

    public void setDebug(boolean debug) {
        this.proxy.setDebug(debug);
    }

    public void setPersistentAuth(boolean persistentAuth) {
        this.proxy.setPersistentAuth(persistentAuth);
    }

    public boolean isPersistentAuth() {
        return this.proxy.isPersistentAuth();
    }

    public boolean isFilter() {
        return this.proxy.isFilter();
    }

    public boolean isDebug() {
        return this.proxy.isDebug();
    }

    public void setSessionid(String sessionid) {
        this.proxy.setSessionid(sessionid);
    }

    public boolean isSetSessionid() {
        return this.proxy.isSetSessionid();
    }

    public void shutdown() {
        this.proxy.shutdown();
    }

    public synchronized Networks getNetworks() {
        if (this.networks == null) {
            this.networks = new Networks(this.proxy);
        }
        return this.networks;
    }

    public synchronized Tags getTags() {
        if (this.tags == null) {
            this.tags = new Tags(this.proxy);
        }
        return this.tags;
    }

    public synchronized Users getUsers() {
        if (this.users == null) {
            this.users = new Users(this.proxy);
        }
        return this.users;
    }

    public synchronized Templates getTemplates() {
        if (this.templates == null) {
            this.templates = new Templates(this.proxy);
        }
        return this.templates;
    }

    public synchronized Events getEvents() {
        if (this.events == null) {
            this.events = new Events(this.proxy);
        }
        return this.events;
    }

    public synchronized Domains getDomains() {
        if (this.domains == null) {
            this.domains = new Domains(this.proxy);
        }
        return this.domains;
    }

    public synchronized Disks getDisks() {
        if (this.disks == null) {
            this.disks = new Disks(this.proxy);
        }
        return this.disks;
    }

    public synchronized Clusters getClusters() {
        if (this.clusters == null) {
            this.clusters = new Clusters(this.proxy);
        }
        return this.clusters;
    }

    public synchronized DataCenters getDataCenters() {
        if (this.dataCenters == null) {
            this.dataCenters = new DataCenters(this.proxy);
        }
        return this.dataCenters;
    }

    public synchronized Roles getRoles() {
        if (this.roles == null) {
            this.roles = new Roles(this.proxy);
        }
        return this.roles;
    }

    public synchronized Hosts getHosts() {
        if (this.hosts == null) {
            this.hosts = new Hosts(this.proxy);
        }
        return this.hosts;
    }

    public synchronized VMs getVMs() {
        if (this.vMs == null) {
            this.vMs = new VMs(this.proxy);
        }
        return this.vMs;
    }

    public synchronized VmPools getVmPools() {
        if (this.vmPools == null) {
            this.vmPools = new VmPools(this.proxy);
        }
        return this.vmPools;
    }

    public synchronized StorageDomains getStorageDomains() {
        if (this.storageDomains == null) {
            this.storageDomains = new StorageDomains(this.proxy);
        }
        return this.storageDomains;
    }

    public synchronized Groups getGroups() {
        if (this.groups == null) {
            this.groups = new Groups(this.proxy);
        }
        return this.groups;
    }

    public XMLGregorianCalendar getTime() throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        return this.getEntryPoint().getTime();
    }

    public ProductInfo getProductInfo() {
        if (this.entryPoint != null) {
            return this.entryPoint.getProductInfo();
        }
        return null;
    }

    public ApiSummary getSummary() throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        return this.getEntryPoint().getSummary();
    }

    public SpecialObjects getSpecialObjects() {
        if (this.entryPoint != null) {
            return this.entryPoint.getSpecialObjects();
        }
        return null;
    }
}

