/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenter;
import org.ovirt.engine.sdk.decorators.DataCenterStorageDomain;
import org.ovirt.engine.sdk.entities.StorageDomain;
import org.ovirt.engine.sdk.entities.StorageDomains;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class DataCenterStorageDomains
extends CollectionDecorator<StorageDomain, StorageDomains, DataCenterStorageDomain> {
    private DataCenter parent;

    public DataCenterStorageDomains(HttpProxyBroker proxy, DataCenter parent) {
        super(proxy, "storagedomains");
        this.parent = parent;
    }

    @Override
    public List<DataCenterStorageDomain> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, StorageDomains.class, DataCenterStorageDomain.class);
    }

    @Override
    public DataCenterStorageDomain get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, StorageDomain.class, DataCenterStorageDomain.class);
    }

    public List<DataCenterStorageDomain> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, StorageDomains.class, DataCenterStorageDomain.class, headers);
    }

    public DataCenterStorageDomain add(StorageDomain storagedomain) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, storagedomain, StorageDomain.class, DataCenterStorageDomain.class, headers);
    }

    public DataCenterStorageDomain add(StorageDomain storagedomain, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().add("Expect", expect).add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, storagedomain, StorageDomain.class, DataCenterStorageDomain.class, headers);
    }
}

