/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.StorageDomainDiskPermissions;
import org.ovirt.engine.sdk.decorators.StorageDomainDiskStatistics;
import org.ovirt.engine.sdk.entities.Disk;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class StorageDomainDisk
extends Disk {
    private HttpProxyBroker proxy;
    private StorageDomainDiskStatistics storageDomainDiskStatistics;
    private StorageDomainDiskPermissions storageDomainDiskPermissions;

    public StorageDomainDisk(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    @Override
    public synchronized StorageDomainDiskStatistics getStatistics() {
        if (this.storageDomainDiskStatistics == null) {
            this.storageDomainDiskStatistics = new StorageDomainDiskStatistics(this.proxy, this);
        }
        return this.storageDomainDiskStatistics;
    }

    public synchronized StorageDomainDiskPermissions getPermissions() {
        if (this.storageDomainDiskPermissions == null) {
            this.storageDomainDiskPermissions = new StorageDomainDiskPermissions(this.proxy, this);
        }
        return this.storageDomainDiskPermissions;
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

