/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenterStorageDomainDisk;
import org.ovirt.engine.sdk.decorators.DataCenterStorageDomainDiskPermission;
import org.ovirt.engine.sdk.entities.Permission;
import org.ovirt.engine.sdk.entities.Permissions;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class DataCenterStorageDomainDiskPermissions
extends CollectionDecorator<Permission, Permissions, DataCenterStorageDomainDiskPermission> {
    private DataCenterStorageDomainDisk parent;

    public DataCenterStorageDomainDiskPermissions(HttpProxyBroker proxy, DataCenterStorageDomainDisk parent) {
        super(proxy, "permissions");
        this.parent = parent;
    }

    @Override
    public List<DataCenterStorageDomainDiskPermission> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Permissions.class, DataCenterStorageDomainDiskPermission.class);
    }

    @Override
    public DataCenterStorageDomainDiskPermission get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Permission.class, DataCenterStorageDomainDiskPermission.class);
    }

    public DataCenterStorageDomainDiskPermission add(Permission permission) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, permission, Permission.class, DataCenterStorageDomainDiskPermission.class, headers);
    }
}

