/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk;

import java.io.IOException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.http.client.ClientProtocolException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.ovirt.engine.sdk.decorators.Capabilities;
import org.ovirt.engine.sdk.decorators.Clusters;
import org.ovirt.engine.sdk.decorators.DataCenters;
import org.ovirt.engine.sdk.decorators.Disks;
import org.ovirt.engine.sdk.decorators.Domains;
import org.ovirt.engine.sdk.decorators.Events;
import org.ovirt.engine.sdk.decorators.Groups;
import org.ovirt.engine.sdk.decorators.Hosts;
import org.ovirt.engine.sdk.decorators.Networks;
import org.ovirt.engine.sdk.decorators.Roles;
import org.ovirt.engine.sdk.decorators.StorageDomains;
import org.ovirt.engine.sdk.decorators.Tags;
import org.ovirt.engine.sdk.decorators.Templates;
import org.ovirt.engine.sdk.decorators.Users;
import org.ovirt.engine.sdk.decorators.VMs;
import org.ovirt.engine.sdk.decorators.VmPools;
import org.ovirt.engine.sdk.entities.API;
import org.ovirt.engine.sdk.entities.ApiSummary;
import org.ovirt.engine.sdk.entities.ProductInfo;
import org.ovirt.engine.sdk.entities.SpecialObjects;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.exceptions.UnsecuredConnectionAttemptError;
import org.ovirt.engine.sdk.utils.SerializationHelper;
import org.ovirt.engine.sdk.web.ConnectionsPool;
import org.ovirt.engine.sdk.web.ConnectionsPoolBuilder;
import org.ovirt.engine.sdk.web.HttpProxy;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.HttpProxyBuilder;

public class Api {
    private volatile HttpProxyBroker proxy = null;
    private volatile API entryPoint = null;
    private final Object LOCK = new Object();
    private volatile Networks networks;
    private volatile Tags tags;
    private volatile Users users;
    private volatile Templates templates;
    private volatile Events events;
    private volatile Domains domains;
    private volatile Disks disks;
    private volatile Clusters clusters;
    private volatile DataCenters dataCenters;
    private volatile Roles roles;
    private volatile Hosts hosts;
    private volatile VMs vMs;
    private volatile VmPools vmPools;
    private volatile Capabilities capabilities;
    private volatile StorageDomains storageDomains;
    private volatile Groups groups;

    public Api(String url, String username, String password) throws ClientProtocolException, ServerException, IOException, UnsecuredConnectionAttemptError {
        this.configureLog4J();
        ConnectionsPool pool = new ConnectionsPoolBuilder(url, username, password).build();
        HttpProxy httpProxy = new HttpProxyBuilder(pool).build();
        this.proxy = new HttpProxyBroker(httpProxy);
        this.initResources();
    }

    public Api(String url, String sessionid) throws ClientProtocolException, ServerException, IOException, UnsecuredConnectionAttemptError {
        this.configureLog4J();
        ConnectionsPool pool = new ConnectionsPoolBuilder(url).build();
        HttpProxy httpProxy = new HttpProxyBuilder(pool).sessionid(sessionid).persistentAuth(true).build();
        this.proxy = new HttpProxyBroker(httpProxy);
        this.initResources();
    }

    public Api(String url, String username, String password, boolean noHostVerification) throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        this.configureLog4J();
        ConnectionsPool pool = new ConnectionsPoolBuilder(url, username, password).noHostVerification(noHostVerification).build();
        HttpProxy httpProxy = new HttpProxyBuilder(pool).build();
        this.proxy = new HttpProxyBroker(httpProxy);
        this.initResources();
    }

    public Api(String url, String sessionid, boolean noHostVerification) throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        this.configureLog4J();
        ConnectionsPool pool = new ConnectionsPoolBuilder(url).noHostVerification(noHostVerification).build();
        HttpProxy httpProxy = new HttpProxyBuilder(pool).sessionid(sessionid).persistentAuth(true).build();
        this.proxy = new HttpProxyBroker(httpProxy);
        this.initResources();
    }

    public Api(String url, String username, String password, Boolean noHostVerification, Boolean filter) throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        this.configureLog4J();
        ConnectionsPool pool = new ConnectionsPoolBuilder(url, username, password).noHostVerification(noHostVerification).build();
        HttpProxy httpProxy = new HttpProxyBuilder(pool).filter(filter).build();
        this.proxy = new HttpProxyBroker(httpProxy);
        this.initResources();
    }

    public Api(String url, String username, String password, String sessionid, Integer port, Integer timeout, Boolean persistentAuth, Boolean noHostVerification, Boolean filter, Boolean debug) throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        this.configureLog4J(debug);
        ConnectionsPool pool = new ConnectionsPoolBuilder(url, username, password).port(port).timeout(timeout).noHostVerification(noHostVerification).build();
        HttpProxy httpProxy = new HttpProxyBuilder(pool).sessionid(sessionid).persistentAuth(persistentAuth).filter(filter).debug(debug).build();
        this.proxy = new HttpProxyBroker(httpProxy);
        this.initResources();
    }

    private void configureLog4J() {
        this.configureLog4J(Boolean.FALSE);
    }

    private void configureLog4J(Boolean debug) {
        String patternLayout = "%d %-5p [%c] %m%n";
        if (debug != null && Boolean.TRUE.equals(debug)) {
            Logger rootLogger = Logger.getRootLogger();
            if (!rootLogger.getAllAppenders().hasMoreElements()) {
                rootLogger.setLevel(Level.INFO);
                rootLogger.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout(patternLayout)));
            }
            Logger pkgLogger = rootLogger.getLoggerRepository().getLogger("org.apache.http");
            pkgLogger.setLevel(Level.DEBUG);
            pkgLogger.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout(patternLayout)));
        } else {
            Logger rootLogger = Logger.getRootLogger();
            if (!rootLogger.getAllAppenders().hasMoreElements()) {
                rootLogger.setLevel(Level.OFF);
                rootLogger.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout(patternLayout)));
            }
        }
    }

    private API getEntryPoint() throws ClientProtocolException, ServerException, IOException, UnsecuredConnectionAttemptError {
        String entryPointXML = this.proxy.get(this.proxy.getRoot());
        if (entryPointXML != null && !entryPointXML.equals("")) {
            return SerializationHelper.unmarshall(API.class, entryPointXML);
        }
        throw new UnsecuredConnectionAttemptError();
    }

    private synchronized void initResources() throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        this.entryPoint = this.getEntryPoint();
    }

    public synchronized void setFilter(boolean filter) {
        this.proxy.setFilter(filter);
    }

    public synchronized void setPersistentAuth(boolean persistentAuth) {
        this.proxy.setPersistentAuth(persistentAuth);
    }

    public boolean isPersistentAuth() {
        return this.proxy.isPersistentAuth();
    }

    public boolean isFilter() {
        return this.proxy.isFilter();
    }

    public boolean isDebug() {
        return this.proxy.isDebug();
    }

    public synchronized void setSessionid(String sessionid) {
        this.proxy.setSessionid(sessionid);
    }

    public boolean isSetSessionid() {
        return this.proxy.isSetSessionid();
    }

    public synchronized void shutdown() {
        this.proxy.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Networks getNetworks() {
        if (this.networks == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.networks == null) {
                    this.networks = new Networks(this.proxy);
                }
            }
        }
        return this.networks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tags getTags() {
        if (this.tags == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.tags == null) {
                    this.tags = new Tags(this.proxy);
                }
            }
        }
        return this.tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Users getUsers() {
        if (this.users == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.users == null) {
                    this.users = new Users(this.proxy);
                }
            }
        }
        return this.users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Templates getTemplates() {
        if (this.templates == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.templates == null) {
                    this.templates = new Templates(this.proxy);
                }
            }
        }
        return this.templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Events getEvents() {
        if (this.events == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.events == null) {
                    this.events = new Events(this.proxy);
                }
            }
        }
        return this.events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domains getDomains() {
        if (this.domains == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.domains == null) {
                    this.domains = new Domains(this.proxy);
                }
            }
        }
        return this.domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Disks getDisks() {
        if (this.disks == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.disks == null) {
                    this.disks = new Disks(this.proxy);
                }
            }
        }
        return this.disks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clusters getClusters() {
        if (this.clusters == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.clusters == null) {
                    this.clusters = new Clusters(this.proxy);
                }
            }
        }
        return this.clusters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCenters getDataCenters() {
        if (this.dataCenters == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.dataCenters == null) {
                    this.dataCenters = new DataCenters(this.proxy);
                }
            }
        }
        return this.dataCenters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Roles getRoles() {
        if (this.roles == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.roles == null) {
                    this.roles = new Roles(this.proxy);
                }
            }
        }
        return this.roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hosts getHosts() {
        if (this.hosts == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.hosts == null) {
                    this.hosts = new Hosts(this.proxy);
                }
            }
        }
        return this.hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VMs getVMs() {
        if (this.vMs == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.vMs == null) {
                    this.vMs = new VMs(this.proxy);
                }
            }
        }
        return this.vMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VmPools getVmPools() {
        if (this.vmPools == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.vmPools == null) {
                    this.vmPools = new VmPools(this.proxy);
                }
            }
        }
        return this.vmPools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.capabilities == null) {
                    this.capabilities = new Capabilities(this.proxy);
                }
            }
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageDomains getStorageDomains() {
        if (this.storageDomains == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.storageDomains == null) {
                    this.storageDomains = new StorageDomains(this.proxy);
                }
            }
        }
        return this.storageDomains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Groups getGroups() {
        if (this.groups == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.groups == null) {
                    this.groups = new Groups(this.proxy);
                }
            }
        }
        return this.groups;
    }

    public XMLGregorianCalendar getTime() throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        return this.getEntryPoint().getTime();
    }

    public SpecialObjects getSpecialObjects() {
        if (this.entryPoint != null) {
            return this.entryPoint.getSpecialObjects();
        }
        return null;
    }

    public ProductInfo getProductInfo() {
        if (this.entryPoint != null) {
            return this.entryPoint.getProductInfo();
        }
        return null;
    }

    public ApiSummary getSummary() throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        return this.getEntryPoint().getSummary();
    }

    public String getComment() throws ClientProtocolException, ServerException, UnsecuredConnectionAttemptError, IOException {
        return this.getEntryPoint().getComment();
    }
}

