/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.ClusterGlusterVolumes;
import org.ovirt.engine.sdk.decorators.ClusterNetworks;
import org.ovirt.engine.sdk.decorators.ClusterPermissions;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class Cluster
extends org.ovirt.engine.sdk.entities.Cluster {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile ClusterGlusterVolumes clusterGlusterVolumes;
    private volatile ClusterNetworks clusterNetworks;
    private volatile ClusterPermissions clusterPermissions;

    public Cluster(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterGlusterVolumes getGlusterVolumes() {
        if (this.clusterGlusterVolumes == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.clusterGlusterVolumes == null) {
                    this.clusterGlusterVolumes = new ClusterGlusterVolumes(this.proxy, this);
                }
            }
        }
        return this.clusterGlusterVolumes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterNetworks getNetworks() {
        if (this.clusterNetworks == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.clusterNetworks == null) {
                    this.clusterNetworks = new ClusterNetworks(this.proxy, this);
                }
            }
        }
        return this.clusterNetworks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterPermissions getPermissions() {
        if (this.clusterPermissions == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.clusterPermissions == null) {
                    this.clusterPermissions = new ClusterPermissions(this.proxy, this);
                }
            }
        }
        return this.clusterPermissions;
    }

    public Cluster update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.Cluster.class, Cluster.class);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

