/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenter;
import org.ovirt.engine.sdk.decorators.DataCenterPermission;
import org.ovirt.engine.sdk.entities.Permission;
import org.ovirt.engine.sdk.entities.Permissions;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class DataCenterPermissions
extends CollectionDecorator<Permission, Permissions, DataCenterPermission> {
    private DataCenter parent;

    public DataCenterPermissions(HttpProxyBroker proxy, DataCenter parent) {
        super(proxy, "permissions");
        this.parent = parent;
    }

    @Override
    public List<DataCenterPermission> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Permissions.class, DataCenterPermission.class);
    }

    @Override
    public DataCenterPermission get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Permission.class, DataCenterPermission.class);
    }

    public DataCenterPermission add(Permission permission) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, permission, Permission.class, DataCenterPermission.class, headers);
    }

    public DataCenterPermission add(Permission permission, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().add("Expect", expect).add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, permission, Permission.class, DataCenterPermission.class, headers);
    }
}

