/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.DataCenterStorageDomainDiskPermissions;
import org.ovirt.engine.sdk.decorators.DataCenterStorageDomainDiskStatistics;
import org.ovirt.engine.sdk.entities.Disk;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class DataCenterStorageDomainDisk
extends Disk {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile DataCenterStorageDomainDiskPermissions dataCenterStorageDomainDiskPermissions;
    private volatile DataCenterStorageDomainDiskStatistics dataCenterStorageDomainDiskStatistics;

    public DataCenterStorageDomainDisk(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCenterStorageDomainDiskPermissions getPermissions() {
        if (this.dataCenterStorageDomainDiskPermissions == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.dataCenterStorageDomainDiskPermissions == null) {
                    this.dataCenterStorageDomainDiskPermissions = new DataCenterStorageDomainDiskPermissions(this.proxy, this);
                }
            }
        }
        return this.dataCenterStorageDomainDiskPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataCenterStorageDomainDiskStatistics getStatistics() {
        if (this.dataCenterStorageDomainDiskStatistics == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.dataCenterStorageDomainDiskStatistics == null) {
                    this.dataCenterStorageDomainDiskStatistics = new DataCenterStorageDomainDiskStatistics(this.proxy, this);
                }
            }
        }
        return this.dataCenterStorageDomainDiskStatistics;
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

