/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Role;
import org.ovirt.engine.sdk.decorators.RolePermit;
import org.ovirt.engine.sdk.entities.Permit;
import org.ovirt.engine.sdk.entities.Permits;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class RolePermits
extends CollectionDecorator<Permit, Permits, RolePermit> {
    private Role parent;

    public RolePermits(HttpProxyBroker proxy, Role parent) {
        super(proxy, "permits");
        this.parent = parent;
    }

    @Override
    public List<RolePermit> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Permits.class, RolePermit.class);
    }

    @Override
    public RolePermit get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Permit.class, RolePermit.class);
    }

    public List<RolePermit> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Permits.class, RolePermit.class, headers);
    }

    public RolePermit add(Permit permit) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, permit, Permit.class, RolePermit.class, headers);
    }

    public RolePermit add(Permit permit, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().add("Expect", expect).add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, permit, Permit.class, RolePermit.class, headers);
    }
}

