/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.TemplateCdRoms;
import org.ovirt.engine.sdk.decorators.TemplateDisks;
import org.ovirt.engine.sdk.decorators.TemplateNICs;
import org.ovirt.engine.sdk.decorators.TemplatePermissions;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class Template
extends org.ovirt.engine.sdk.entities.Template {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile TemplateCdRoms templateCdRoms;
    private volatile TemplateNICs templateNICs;
    private volatile TemplatePermissions templatePermissions;
    private volatile TemplateDisks templateDisks;

    public Template(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateCdRoms getCdRoms() {
        if (this.templateCdRoms == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.templateCdRoms == null) {
                    this.templateCdRoms = new TemplateCdRoms(this.proxy, this);
                }
            }
        }
        return this.templateCdRoms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateNICs getNics() {
        if (this.templateNICs == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.templateNICs == null) {
                    this.templateNICs = new TemplateNICs(this.proxy, this);
                }
            }
        }
        return this.templateNICs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplatePermissions getPermissions() {
        if (this.templatePermissions == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.templatePermissions == null) {
                    this.templatePermissions = new TemplatePermissions(this.proxy, this);
                }
            }
        }
        return this.templatePermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateDisks getDisks() {
        if (this.templateDisks == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.templateDisks == null) {
                    this.templateDisks = new TemplateDisks(this.proxy, this);
                }
            }
        }
        return this.templateDisks;
    }

    public Template update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.Template.class, Template.class);
    }

    public Action exportTemplate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/export";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action exportTemplate(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/export";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

