/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.web;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.ovirt.engine.sdk.utils.StringUtils;
import org.ovirt.engine.sdk.web.ConnectionsPool;

public class ConnectionsPoolBuilder {
    private static final String BAD_PROTOCOL_ERROR = "Unsupported protocol ";
    private static final String BAD_KEY_ERROR = "SSL context initiation has failed because of key error.";
    private static final String NO_TLS_ERROR = "SSL context initiation has failed locating TLS slgorithm.";
    private static int MAX_CONNECTIONS = 20;
    private static int MAX_CONNECTIONS_PER_HOST = 50;
    private static int MAX_CONNECTIONS_PER_ROUTE = 5;
    private static long WAIT_IDLE_CHECK_TTL = 5000L;
    private static long WAIT_IDLE_CLOSE_TTL = 30L;
    private static String HTTP_PROTOCOL = "http";
    private static String HTTPS_PROTOCOL = "https";
    private String url;
    private String username;
    private String password;
    private String key_file;
    private String cert_file;
    private String ca_file;
    private int port = -1;
    private int timeout = -1;
    private boolean noHostVerification = false;
    private URL urlobj = null;
    X509TrustManager noCaTrustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };

    public ConnectionsPoolBuilder(String url, String username, String password) throws MalformedURLException {
        this.url(url);
        this.username(username);
        this.password(password);
    }

    public ConnectionsPoolBuilder(String url) throws MalformedURLException {
        this.url(url);
    }

    private ConnectionsPoolBuilder url(String url) throws MalformedURLException {
        this.url = url;
        this.urlobj = this.createURL(url);
        return this;
    }

    private ConnectionsPoolBuilder username(String username) {
        this.username = username;
        return this;
    }

    private ConnectionsPoolBuilder password(String password) {
        this.password = password;
        return this;
    }

    public ConnectionsPoolBuilder key_file(String key_file) {
        this.key_file = key_file;
        return this;
    }

    public ConnectionsPoolBuilder cert_file(String cert_file) {
        this.cert_file = cert_file;
        return this;
    }

    public ConnectionsPoolBuilder ca_file(String ca_file) {
        this.ca_file = ca_file;
        return this;
    }

    public ConnectionsPoolBuilder port(Integer port) {
        if (port != null) {
            this.port = port;
        }
        return this;
    }

    public ConnectionsPoolBuilder timeout(Integer timeout) {
        if (timeout != null) {
            this.timeout = timeout;
        }
        return this;
    }

    public ConnectionsPoolBuilder noHostVerification(Boolean noHostVerification) {
        if (noHostVerification != null) {
            this.noHostVerification = noHostVerification;
        }
        return this;
    }

    private DefaultHttpClient createDefaultHttpClient(String url, String username, String password, String key_file, String cert_file, String ca_file, Integer port, Integer timeout) {
        int port_ = this.getPort(url, port);
        DefaultHttpClient client = new DefaultHttpClient(this.createPoolingClientConnectionManager(url, port_));
        if (!StringUtils.isNulOrEmpty(username)) {
            client.getCredentialsProvider().setCredentials(new AuthScope(this.getHost(url), port_), (Credentials)new UsernamePasswordCredentials(username, password));
        }
        return client;
    }

    private ClientConnectionManager createPoolingClientConnectionManager(String url, int port) {
        SchemeRegistry schemeRegistry = this.createSchemeRegistry(url, port);
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
        cm.setMaxTotal(MAX_CONNECTIONS);
        cm.setDefaultMaxPerRoute(MAX_CONNECTIONS_PER_ROUTE);
        cm.setMaxPerRoute(new HttpRoute(new HttpHost(this.getHost(url), this.getPort(url, port))), MAX_CONNECTIONS_PER_HOST);
        return cm;
    }

    private SchemeRegistry createSchemeRegistry(String url, int port) {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        String protocol = this.getProtocol(url);
        if (HTTP_PROTOCOL.equals(protocol)) {
            schemeRegistry.register(new Scheme(HTTP_PROTOCOL, port, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        } else if (HTTPS_PROTOCOL.equals(protocol)) {
            try {
                SSLSocketFactory sf;
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                if (this.noHostVerification) {
                    sslcontext.init(null, new TrustManager[]{this.noCaTrustManager}, null);
                    sf = new SSLSocketFactory(sslcontext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                } else {
                    sslcontext.init(null, null, null);
                    sf = new SSLSocketFactory(sslcontext, SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
                }
                schemeRegistry.register(new Scheme(HTTPS_PROTOCOL, port, (SchemeSocketFactory)sf));
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                throw new RuntimeException(NO_TLS_ERROR, e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(BAD_KEY_ERROR, e);
            }
        } else {
            throw new RuntimeException(BAD_PROTOCOL_ERROR + protocol);
        }
        return schemeRegistry;
    }

    private int getPort(String url, Integer port) {
        return port == null || port == -1 ? this.urlobj.getPort() : port.intValue();
    }

    private String getHost(String url) {
        return this.urlobj.getHost();
    }

    private String getProtocol(String url) {
        return this.urlobj.getProtocol();
    }

    public String getUrl() {
        return this.url.toString();
    }

    private URL createURL(String url) throws MalformedURLException {
        return new URL(url);
    }

    public ConnectionsPool build() {
        return new ConnectionsPool(this.createDefaultHttpClient(this.url, this.username, this.password, this.key_file, this.cert_file, this.ca_file, this.port, this.timeout), this.urlobj, WAIT_IDLE_CHECK_TTL, WAIT_IDLE_CLOSE_TTL);
    }
}

