/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenterCluster;
import org.ovirt.engine.sdk.decorators.DataCenterClusterGlusterVolume;
import org.ovirt.engine.sdk.entities.GlusterVolume;
import org.ovirt.engine.sdk.entities.GlusterVolumes;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class DataCenterClusterGlusterVolumes
extends CollectionDecorator<GlusterVolume, GlusterVolumes, DataCenterClusterGlusterVolume> {
    private DataCenterCluster parent;

    public DataCenterClusterGlusterVolumes(HttpProxyBroker proxy, DataCenterCluster parent) {
        super(proxy, "glustervolumes");
        this.parent = parent;
    }

    @Override
    public List<DataCenterClusterGlusterVolume> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, GlusterVolumes.class, DataCenterClusterGlusterVolume.class);
    }

    @Override
    public DataCenterClusterGlusterVolume get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, GlusterVolume.class, DataCenterClusterGlusterVolume.class);
    }

    public DataCenterClusterGlusterVolume add(GlusterVolume glustervolume) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, glustervolume, GlusterVolume.class, DataCenterClusterGlusterVolume.class, headers);
    }
}

