/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.JobSteps;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class Job
extends org.ovirt.engine.sdk.entities.Job {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile JobSteps jobSteps;

    public Job(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobSteps getSteps() {
        if (this.jobSteps == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.jobSteps == null) {
                    this.jobSteps = new JobSteps(this.proxy, this);
                }
            }
        }
        return this.jobSteps;
    }

    public Action clear(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/clear";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action clear(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/clear";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action end(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/end";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action end(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/end";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }
}

