/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.StorageDomain;
import org.ovirt.engine.sdk.decorators.StorageDomainStorageConnection;
import org.ovirt.engine.sdk.entities.StorageConnection;
import org.ovirt.engine.sdk.entities.StorageConnections;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class StorageDomainStorageConnections
extends CollectionDecorator<StorageConnection, StorageConnections, StorageDomainStorageConnection> {
    private StorageDomain parent;

    public StorageDomainStorageConnections(HttpProxyBroker proxy, StorageDomain parent) {
        super(proxy, "storageconnections");
        this.parent = parent;
    }

    @Override
    public List<StorageDomainStorageConnection> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, StorageConnections.class, StorageDomainStorageConnection.class);
    }

    @Override
    public StorageDomainStorageConnection get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, StorageConnection.class, StorageDomainStorageConnection.class);
    }

    public List<StorageDomainStorageConnection> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, StorageConnections.class, StorageDomainStorageConnection.class, headers);
    }

    public StorageDomainStorageConnection add(StorageConnection storageconnection) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, storageconnection, StorageConnection.class, StorageDomainStorageConnection.class, headers);
    }

    public StorageDomainStorageConnection add(StorageConnection storageconnection, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, storageconnection, StorageConnection.class, StorageDomainStorageConnection.class, headers);
    }
}

