/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Template;
import org.ovirt.engine.sdk.decorators.TemplateCdRom;
import org.ovirt.engine.sdk.entities.CdRom;
import org.ovirt.engine.sdk.entities.CdRoms;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class TemplateCdRoms
extends CollectionDecorator<CdRom, CdRoms, TemplateCdRom> {
    private Template parent;

    public TemplateCdRoms(HttpProxyBroker proxy, Template parent) {
        super(proxy, "cdroms");
        this.parent = parent;
    }

    @Override
    public List<TemplateCdRom> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, CdRoms.class, TemplateCdRom.class);
    }

    @Override
    public TemplateCdRom get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, CdRom.class, TemplateCdRom.class);
    }

    public List<TemplateCdRom> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, CdRoms.class, TemplateCdRom.class, headers);
    }
}

