/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.DataCenterClusters;
import org.ovirt.engine.sdk.decorators.DataCenterPermissions;
import org.ovirt.engine.sdk.decorators.DataCenterQuotas;
import org.ovirt.engine.sdk.decorators.DataCenterStorageDomains;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class DataCenter
extends org.ovirt.engine.sdk.entities.DataCenter {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile DataCenterClusters dataCenterClusters;
    private volatile DataCenterPermissions dataCenterPermissions;
    private volatile DataCenterStorageDomains dataCenterStorageDomains;
    private volatile DataCenterQuotas dataCenterQuotas;

    public DataCenter(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCenterClusters getClusters() {
        if (this.dataCenterClusters == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.dataCenterClusters == null) {
                    this.dataCenterClusters = new DataCenterClusters(this.proxy, this);
                }
            }
        }
        return this.dataCenterClusters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCenterPermissions getPermissions() {
        if (this.dataCenterPermissions == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.dataCenterPermissions == null) {
                    this.dataCenterPermissions = new DataCenterPermissions(this.proxy, this);
                }
            }
        }
        return this.dataCenterPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCenterStorageDomains getStorageDomains() {
        if (this.dataCenterStorageDomains == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.dataCenterStorageDomains == null) {
                    this.dataCenterStorageDomains = new DataCenterStorageDomains(this.proxy, this);
                }
            }
        }
        return this.dataCenterStorageDomains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCenterQuotas getQuotas() {
        if (this.dataCenterQuotas == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.dataCenterQuotas == null) {
                    this.dataCenterQuotas = new DataCenterQuotas(this.proxy, this);
                }
            }
        }
        return this.dataCenterQuotas;
    }

    public DataCenter update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.DataCenter.class, DataCenter.class, headers);
    }

    public DataCenter update(String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.DataCenter.class, DataCenter.class, headers);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Action action, Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, action, Action.class, Response.class, headers);
    }
}

