/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Cluster;
import org.ovirt.engine.sdk.decorators.ClusterGlusterVolume;
import org.ovirt.engine.sdk.entities.GlusterVolume;
import org.ovirt.engine.sdk.entities.GlusterVolumes;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class ClusterGlusterVolumes
extends CollectionDecorator<GlusterVolume, GlusterVolumes, ClusterGlusterVolume> {
    private Cluster parent;

    public ClusterGlusterVolumes(HttpProxyBroker proxy, Cluster parent) {
        super(proxy, "glustervolumes");
        this.parent = parent;
    }

    @Override
    public List<ClusterGlusterVolume> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, GlusterVolumes.class, ClusterGlusterVolume.class);
    }

    @Override
    public ClusterGlusterVolume get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, GlusterVolume.class, ClusterGlusterVolume.class);
    }

    public List<ClusterGlusterVolume> list(String query, Boolean caseSensitive) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("search", query, UrlParameterType.QUERY).add("case_sensitive", caseSensitive, UrlParameterType.MATRIX).build();
        return this.list(url, GlusterVolumes.class, ClusterGlusterVolume.class, headers);
    }

    public ClusterGlusterVolume add(GlusterVolume glustervolume) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, glustervolume, GlusterVolume.class, ClusterGlusterVolume.class, headers);
    }

    public ClusterGlusterVolume add(GlusterVolume glustervolume, Boolean force, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().add("Expect", expect).add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("force", force, UrlParameterType.MATRIX).build();
        return this.getProxy().add(url, glustervolume, GlusterVolume.class, ClusterGlusterVolume.class, headers);
    }
}

