/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.DataCenterNetworkPermissions;
import org.ovirt.engine.sdk.decorators.DataCenterNetworkVnicProfiles;
import org.ovirt.engine.sdk.entities.Network;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class DataCenterNetwork
extends Network {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile DataCenterNetworkPermissions dataCenterNetworkPermissions;
    private volatile DataCenterNetworkVnicProfiles dataCenterNetworkVnicProfiles;

    public DataCenterNetwork(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCenterNetworkPermissions getPermissions() {
        if (this.dataCenterNetworkPermissions == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.dataCenterNetworkPermissions == null) {
                    this.dataCenterNetworkPermissions = new DataCenterNetworkPermissions(this.proxy, this);
                }
            }
        }
        return this.dataCenterNetworkPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCenterNetworkVnicProfiles getVnicProfiles() {
        if (this.dataCenterNetworkVnicProfiles == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.dataCenterNetworkVnicProfiles == null) {
                    this.dataCenterNetworkVnicProfiles = new DataCenterNetworkVnicProfiles(this.proxy, this);
                }
            }
        }
        return this.dataCenterNetworkVnicProfiles;
    }

    public DataCenterNetwork update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().update(url, this, Network.class, DataCenterNetwork.class, headers);
    }

    public DataCenterNetwork update(String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().update(url, this, Network.class, DataCenterNetwork.class, headers);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

