/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Domain;
import org.ovirt.engine.sdk.decorators.DomainUser;
import org.ovirt.engine.sdk.entities.User;
import org.ovirt.engine.sdk.entities.Users;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class DomainUsers
extends CollectionDecorator<User, Users, DomainUser> {
    private Domain parent;

    public DomainUsers(HttpProxyBroker proxy, Domain parent) {
        super(proxy, "users");
        this.parent = parent;
    }

    @Override
    public List<DomainUser> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Users.class, DomainUser.class);
    }

    @Override
    public DomainUser get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, User.class, DomainUser.class);
    }

    public List<DomainUser> list(String query, Boolean caseSensitive, Integer max) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("search", query, UrlParameterType.QUERY).add("case_sensitive", caseSensitive, UrlParameterType.MATRIX).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Users.class, DomainUser.class, headers);
    }
}

