/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Host;
import org.ovirt.engine.sdk.decorators.HostNIC;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.HostNics;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class HostNICs
extends CollectionDecorator<org.ovirt.engine.sdk.entities.HostNIC, HostNics, HostNIC> {
    private Host parent;

    public HostNICs(HttpProxyBroker proxy, Host parent) {
        super(proxy, "nics");
        this.parent = parent;
    }

    @Override
    public List<HostNIC> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, HostNics.class, HostNIC.class);
    }

    @Override
    public HostNIC get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, org.ovirt.engine.sdk.entities.HostNIC.class, HostNIC.class);
    }

    public Action setupnetworks(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + "setupnetworks";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action setupnetworks(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + "setupnetworks";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public List<HostNIC> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, HostNics.class, HostNIC.class, headers);
    }

    public HostNIC add(org.ovirt.engine.sdk.entities.HostNIC hostnic) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, hostnic, org.ovirt.engine.sdk.entities.HostNIC.class, HostNIC.class, headers);
    }

    public HostNIC add(org.ovirt.engine.sdk.entities.HostNIC hostnic, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().add("Expect", expect).add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, hostnic, org.ovirt.engine.sdk.entities.HostNIC.class, HostNIC.class, headers);
    }
}

