/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Host;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class Hosts
extends CollectionDecorator<org.ovirt.engine.sdk.entities.Host, org.ovirt.engine.sdk.entities.Hosts, Host> {
    public Hosts(HttpProxyBroker proxy) {
        super(proxy, "hosts");
    }

    @Override
    public List<Host> list() throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        return this.list(url, org.ovirt.engine.sdk.entities.Hosts.class, Host.class);
    }

    @Override
    public Host get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, org.ovirt.engine.sdk.entities.Host.class, Host.class);
    }

    public List<Host> list(String query, Boolean caseSensitive, Integer max) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder("/" + this.getName()).add("search", query, UrlParameterType.QUERY).add("case_sensitive", caseSensitive, UrlParameterType.MATRIX).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, org.ovirt.engine.sdk.entities.Hosts.class, Host.class, headers);
    }

    public Host add(org.ovirt.engine.sdk.entities.Host host) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, host, org.ovirt.engine.sdk.entities.Host.class, Host.class, headers);
    }

    public Host add(org.ovirt.engine.sdk.entities.Host host, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().add("Expect", expect).add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, host, org.ovirt.engine.sdk.entities.Host.class, Host.class, headers);
    }
}

