/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.JobStep;
import org.ovirt.engine.sdk.decorators.JobStepStatistic;
import org.ovirt.engine.sdk.entities.Statistic;
import org.ovirt.engine.sdk.entities.Statistics;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class JobStepStatistics
extends CollectionDecorator<Statistic, Statistics, JobStepStatistic> {
    private JobStep parent;

    public JobStepStatistics(HttpProxyBroker proxy, JobStep parent) {
        super(proxy, "statistics");
        this.parent = parent;
    }

    @Override
    public List<JobStepStatistic> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Statistics.class, JobStepStatistic.class);
    }

    @Override
    public JobStepStatistic get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Statistic.class, JobStepStatistic.class);
    }

    public List<JobStepStatistic> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Statistics.class, JobStepStatistic.class, headers);
    }
}

