/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.NetworkVnicProfilePermissions;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.entities.VnicProfile;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class NetworkVnicProfile
extends VnicProfile {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile NetworkVnicProfilePermissions networkVnicProfilePermissions;

    public NetworkVnicProfile(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkVnicProfilePermissions getPermissions() {
        if (this.networkVnicProfilePermissions == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.networkVnicProfilePermissions == null) {
                    this.networkVnicProfilePermissions = new NetworkVnicProfilePermissions(this.proxy, this);
                }
            }
        }
        return this.networkVnicProfilePermissions;
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

