/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.NetworkVnicProfile;
import org.ovirt.engine.sdk.decorators.NetworkVnicProfilePermission;
import org.ovirt.engine.sdk.entities.Permission;
import org.ovirt.engine.sdk.entities.Permissions;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class NetworkVnicProfilePermissions
extends CollectionDecorator<Permission, Permissions, NetworkVnicProfilePermission> {
    private NetworkVnicProfile parent;

    public NetworkVnicProfilePermissions(HttpProxyBroker proxy, NetworkVnicProfile parent) {
        super(proxy, "permissions");
        this.parent = parent;
    }

    @Override
    public List<NetworkVnicProfilePermission> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Permissions.class, NetworkVnicProfilePermission.class);
    }

    @Override
    public NetworkVnicProfilePermission get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Permission.class, NetworkVnicProfilePermission.class);
    }

    public NetworkVnicProfilePermission add(Permission permission) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, permission, Permission.class, NetworkVnicProfilePermission.class, headers);
    }
}

