/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Network;
import org.ovirt.engine.sdk.decorators.NetworkVnicProfile;
import org.ovirt.engine.sdk.entities.VnicProfile;
import org.ovirt.engine.sdk.entities.VnicProfiles;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class NetworkVnicProfiles
extends CollectionDecorator<VnicProfile, VnicProfiles, NetworkVnicProfile> {
    private Network parent;

    public NetworkVnicProfiles(HttpProxyBroker proxy, Network parent) {
        super(proxy, "vnicprofiles");
        this.parent = parent;
    }

    @Override
    public List<NetworkVnicProfile> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, VnicProfiles.class, NetworkVnicProfile.class);
    }

    @Override
    public NetworkVnicProfile get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, VnicProfile.class, NetworkVnicProfile.class);
    }

    public List<NetworkVnicProfile> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, VnicProfiles.class, NetworkVnicProfile.class, headers);
    }

    public NetworkVnicProfile add(VnicProfile vnicprofile) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, vnicprofile, VnicProfile.class, NetworkVnicProfile.class, headers);
    }

    public NetworkVnicProfile add(VnicProfile vnicprofile, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().add("Expect", expect).add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, vnicprofile, VnicProfile.class, NetworkVnicProfile.class, headers);
    }
}

