/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.StorageDomain;
import org.ovirt.engine.sdk.decorators.StorageDomainDisk;
import org.ovirt.engine.sdk.entities.Disk;
import org.ovirt.engine.sdk.entities.Disks;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class StorageDomainDisks
extends CollectionDecorator<Disk, Disks, StorageDomainDisk> {
    private StorageDomain parent;

    public StorageDomainDisks(HttpProxyBroker proxy, StorageDomain parent) {
        super(proxy, "disks");
        this.parent = parent;
    }

    @Override
    public List<StorageDomainDisk> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Disks.class, StorageDomainDisk.class);
    }

    @Override
    public StorageDomainDisk get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Disk.class, StorageDomainDisk.class);
    }

    public List<StorageDomainDisk> list(String query, Boolean caseSensitive, Integer max, Boolean unregistered) throws ClientProtocolException, ServerException, IOException {
        List<Header> headers = new HttpHeaderBuilder().build();
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("search", query, UrlParameterType.QUERY).add("case_sensitive", caseSensitive, UrlParameterType.MATRIX).add("max", max, UrlParameterType.MATRIX).add("unregistered", unregistered, UrlParameterType.MATRIX).build();
        return this.list(url, Disks.class, StorageDomainDisk.class, headers);
    }

    public StorageDomainDisk add(Disk disk) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().add(url, disk, Disk.class, StorageDomainDisk.class, headers);
    }

    public StorageDomainDisk add(Disk disk, Boolean unregistered, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        List<Header> headers = new HttpHeaderBuilder().add("Expect", expect).add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("unregistered", unregistered, UrlParameterType.MATRIX).build();
        return this.getProxy().add(url, disk, Disk.class, StorageDomainDisk.class, headers);
    }
}

