/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.ovirt.engine.sdk.exceptions.ProtocolException;
import org.ovirt.engine.sdk.exceptions.SocketFactoryException;
import org.ovirt.engine.sdk.utils.StringUtils;
import org.ovirt.engine.sdk.web.ConnectionsPool;

public class ConnectionsPoolBuilder {
    private static final String DEFAULT_KEYSTORE_TRUSTSTORE = "ovirtsdk-keystore.truststore";
    private static final String BAD_PROTOCOL_ERROR = "Unsupported protocol ";
    private static final String BAD_KEY_ERROR = "SSL context initiation has failed because of key error.";
    private static final String NO_TLS_ERROR = "SSL context initiation has failed locating TLS slgorithm.";
    private static final String KEY_STORE_ERROR = "CA certeficate keysotore initiation has failed.";
    private static final String KEY_STORE_FILE_NOT_FOUND_ERROR = "CA certeficate keysotore was not found.";
    private static final String CERTEFICATE_ERROR = "CA certeficate error.";
    private static final String IO_ERROR = "I/O error occured, is your keysotore password correct?";
    private static final String UNRECOVERABLE_KEY_ERROR = "Unrecoverable key error has occured.";
    private static int MAX_CONNECTIONS = 20;
    private static int MAX_CONNECTIONS_PER_HOST = 50;
    private static int MAX_CONNECTIONS_PER_ROUTE = 5;
    private static long WAIT_IDLE_CHECK_TTL = 5000L;
    private static long WAIT_IDLE_CLOSE_TTL = 30L;
    private static String HTTP_PROTOCOL = "http";
    private static String HTTPS_PROTOCOL = "https";
    private String url;
    private String username;
    private String password;
    private String key_file;
    private String cert_file;
    private String ca_file;
    private int port = -1;
    private Integer requestTimeout;
    private Integer sessionTimeout;
    private boolean noHostVerification = false;
    private String keyStorePath;
    private String keyStorePassword;
    private URL urlobj = null;
    X509TrustManager noCaTrustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };

    public ConnectionsPoolBuilder(String url, String username, String password) throws MalformedURLException {
        this.url(url);
        this.username(username);
        this.password(password);
    }

    public ConnectionsPoolBuilder(String url) throws MalformedURLException {
        this.url(url);
    }

    private ConnectionsPoolBuilder url(String url) throws MalformedURLException {
        this.url = url;
        this.urlobj = this.createURL(url);
        return this;
    }

    private ConnectionsPoolBuilder username(String username) {
        this.username = username;
        return this;
    }

    private ConnectionsPoolBuilder password(String password) {
        this.password = password;
        return this;
    }

    public ConnectionsPoolBuilder key_file(String key_file) {
        this.key_file = key_file;
        return this;
    }

    public ConnectionsPoolBuilder cert_file(String cert_file) {
        this.cert_file = cert_file;
        return this;
    }

    public ConnectionsPoolBuilder ca_file(String ca_file) {
        this.ca_file = ca_file;
        return this;
    }

    public ConnectionsPoolBuilder keyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public ConnectionsPoolBuilder keyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public ConnectionsPoolBuilder port(Integer port) {
        if (port != null) {
            this.port = port;
        }
        return this;
    }

    public ConnectionsPoolBuilder requestTimeout(Integer requestTimeout) {
        if (requestTimeout != null) {
            this.requestTimeout = requestTimeout;
        }
        return this;
    }

    public ConnectionsPoolBuilder sessionTimeout(Integer sessionTimeout) {
        if (sessionTimeout != null) {
            this.sessionTimeout = sessionTimeout;
        }
        return this;
    }

    public ConnectionsPoolBuilder noHostVerification(Boolean noHostVerification) {
        if (noHostVerification != null) {
            this.noHostVerification = noHostVerification;
        }
        return this;
    }

    private DefaultHttpClient createDefaultHttpClient(String url, String username, String password, String key_file, String cert_file, String ca_file, Integer port, Integer requestTimeout) {
        int port_ = this.getPort(url, port);
        DefaultHttpClient client = new DefaultHttpClient(this.createPoolingClientConnectionManager(url, port_));
        if (requestTimeout != null && requestTimeout != -1) {
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)requestTimeout);
            DefaultHttpClient.setDefaultHttpParams((HttpParams)httpParams);
        }
        if (!StringUtils.isNulOrEmpty(username)) {
            client.getCredentialsProvider().setCredentials(new AuthScope(this.getHost(url), port_), (Credentials)new UsernamePasswordCredentials(username, password));
        }
        return client;
    }

    private ClientConnectionManager createPoolingClientConnectionManager(String url, int port) {
        SchemeRegistry schemeRegistry = this.createSchemeRegistry(url, port);
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
        cm.setMaxTotal(MAX_CONNECTIONS);
        cm.setDefaultMaxPerRoute(MAX_CONNECTIONS_PER_ROUTE);
        cm.setMaxPerRoute(new HttpRoute(new HttpHost(this.getHost(url), this.getPort(url, port))), MAX_CONNECTIONS_PER_HOST);
        return cm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemeRegistry createSchemeRegistry(String url, int port) {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        String protocol = this.getProtocol(url);
        if (HTTP_PROTOCOL.equals(protocol)) {
            schemeRegistry.register(new Scheme(HTTP_PROTOCOL, port, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        } else {
            if (HTTPS_PROTOCOL.equals(protocol)) {
                try {
                    SSLSocketFactory sf;
                    if (this.noHostVerification) {
                        SSLContext sslcontext = SSLContext.getInstance("TLS");
                        sslcontext.init(null, new TrustManager[]{this.noCaTrustManager}, null);
                        sf = new SSLSocketFactory(sslcontext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                    } else {
                        KeyStore truststore = null;
                        FileInputStream in = null;
                        if (this.keyStorePath != null) {
                            truststore = KeyStore.getInstance(KeyStore.getDefaultType());
                            try {
                                in = new FileInputStream(this.keyStorePath);
                                truststore.load(in, this.keyStorePassword != null ? this.keyStorePassword.toCharArray() : null);
                            }
                            finally {
                                if (in != null) {
                                    ((InputStream)in).close();
                                }
                            }
                        }
                        sf = new SSLSocketFactory("TLS", null, null, truststore, null, null, SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
                    }
                    schemeRegistry.register(new Scheme(HTTPS_PROTOCOL, port, (SchemeSocketFactory)sf));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new SocketFactoryException(NO_TLS_ERROR, e);
                }
                catch (KeyManagementException e) {
                    throw new SocketFactoryException(BAD_KEY_ERROR, e);
                }
                catch (KeyStoreException e) {
                    throw new SocketFactoryException(KEY_STORE_ERROR, e);
                }
                catch (FileNotFoundException e) {
                    throw new SocketFactoryException(KEY_STORE_FILE_NOT_FOUND_ERROR, e);
                }
                catch (CertificateException e) {
                    throw new SocketFactoryException(CERTEFICATE_ERROR, e);
                }
                catch (IOException e) {
                    throw new SocketFactoryException(IO_ERROR, e);
                }
                catch (UnrecoverableKeyException e) {
                    throw new SocketFactoryException(UNRECOVERABLE_KEY_ERROR, e);
                }
            }
            throw new ProtocolException(BAD_PROTOCOL_ERROR + protocol);
        }
        return schemeRegistry;
    }

    private int getPort(String url, Integer port) {
        return port == null || port == -1 ? this.urlobj.getPort() : port.intValue();
    }

    private String getHost(String url) {
        return this.urlobj.getHost();
    }

    private String getProtocol(String url) {
        return this.urlobj.getProtocol();
    }

    public String getUrl() {
        return this.url.toString();
    }

    private URL createURL(String url) throws MalformedURLException {
        return new URL(url);
    }

    public ConnectionsPool build() {
        this.keyStorePath = this.resolveKeyStorePath();
        return new ConnectionsPool(this.createDefaultHttpClient(this.url, this.username, this.password, this.key_file, this.cert_file, this.ca_file, this.port, this.requestTimeout), this.urlobj, this.sessionTimeout, WAIT_IDLE_CHECK_TTL, WAIT_IDLE_CLOSE_TTL);
    }

    private String resolveKeyStorePath() {
        if (this.keyStorePath == null) {
            String keyStorePathCandidate = System.getProperty("user.home") + File.separator + ".ovirtsdk" + File.separator + DEFAULT_KEYSTORE_TRUSTSTORE;
            try {
                if (new File(keyStorePathCandidate).exists()) {
                    return keyStorePathCandidate;
                }
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
        }
        return this.keyStorePath;
    }
}

