/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.HostHooks;
import org.ovirt.engine.sdk.decorators.HostNICs;
import org.ovirt.engine.sdk.decorators.HostPermissions;
import org.ovirt.engine.sdk.decorators.HostStatistics;
import org.ovirt.engine.sdk.decorators.HostTags;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class Host
extends org.ovirt.engine.sdk.entities.Host {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile HostHooks hostHooks;
    private volatile HostNICs hostNICs;
    private volatile HostTags hostTags;
    private volatile HostPermissions hostPermissions;
    private volatile HostStatistics hostStatistics;

    public Host(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostHooks getHooks() {
        if (this.hostHooks == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.hostHooks == null) {
                    this.hostHooks = new HostHooks(this.proxy, this);
                }
            }
        }
        return this.hostHooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostNICs getHostNics() {
        if (this.hostNICs == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.hostNICs == null) {
                    this.hostNICs = new HostNICs(this.proxy, this);
                }
            }
        }
        return this.hostNICs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostTags getTags() {
        if (this.hostTags == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.hostTags == null) {
                    this.hostTags = new HostTags(this.proxy, this);
                }
            }
        }
        return this.hostTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostPermissions getPermissions() {
        if (this.hostPermissions == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.hostPermissions == null) {
                    this.hostPermissions = new HostPermissions(this.proxy, this);
                }
            }
        }
        return this.hostPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostStatistics getStatistics() {
        if (this.hostStatistics == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.hostStatistics == null) {
                    this.hostStatistics = new HostStatistics(this.proxy, this);
                }
            }
        }
        return this.hostStatistics;
    }

    public Action install(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/install";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action install(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/install";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action activate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/activate";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action activate(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/activate";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Host update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.Host.class, Host.class, headers);
    }

    public Host update(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.Host.class, Host.class, headers);
    }

    public Action fence(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/fence";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action fence(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/fence";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action iscsidiscover(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/iscsidiscover";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action iscsidiscover(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/iscsidiscover";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action approve(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/approve";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action approve(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/approve";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action iscsilogin(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/iscsilogin";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action iscsilogin(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/iscsilogin";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action forceselectspm(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/forceselectspm";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action forceselectspm(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/forceselectspm";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Action action, Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, action, Action.class, Response.class, headers);
    }

    public Action deactivate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/deactivate";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action deactivate(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/deactivate";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action commitnetconfig(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/commitnetconfig";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action commitnetconfig(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/commitnetconfig";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }
}

