/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.HostNIC;
import org.ovirt.engine.sdk.decorators.HostNICLabel;
import org.ovirt.engine.sdk.entities.Label;
import org.ovirt.engine.sdk.entities.Labels;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class HostNICLabels
extends CollectionDecorator<Label, Labels, HostNICLabel> {
    private HostNIC parent;

    public HostNICLabels(HttpProxyBroker proxy, HostNIC parent) {
        super(proxy, "labels");
        this.parent = parent;
    }

    @Override
    public List<HostNICLabel> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Labels.class, HostNICLabel.class);
    }

    @Override
    public HostNICLabel get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Label.class, HostNICLabel.class);
    }

    public HostNICLabel add(Label label) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, label, Label.class, HostNICLabel.class, headers);
    }
}

