/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.NetworkLabels;
import org.ovirt.engine.sdk.decorators.NetworkPermissions;
import org.ovirt.engine.sdk.decorators.NetworkVnicProfiles;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class Network
extends org.ovirt.engine.sdk.entities.Network {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile NetworkPermissions networkPermissions;
    private volatile NetworkLabels networkLabels;
    private volatile NetworkVnicProfiles networkVnicProfiles;

    public Network(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkPermissions getPermissions() {
        if (this.networkPermissions == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.networkPermissions == null) {
                    this.networkPermissions = new NetworkPermissions(this.proxy, this);
                }
            }
        }
        return this.networkPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkLabels getLabels() {
        if (this.networkLabels == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.networkLabels == null) {
                    this.networkLabels = new NetworkLabels(this.proxy, this);
                }
            }
        }
        return this.networkLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkVnicProfiles getVnicProfiles() {
        if (this.networkVnicProfiles == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.networkVnicProfiles == null) {
                    this.networkVnicProfiles = new NetworkVnicProfiles(this.proxy, this);
                }
            }
        }
        return this.networkVnicProfiles;
    }

    public Network update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.Network.class, Network.class, headers);
    }

    public Network update(String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.Network.class, Network.class, headers);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

