/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.VMSnapshotCdRoms;
import org.ovirt.engine.sdk.decorators.VMSnapshotDisks;
import org.ovirt.engine.sdk.decorators.VMSnapshotNics;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.entities.Snapshot;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class VMSnapshot
extends Snapshot {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile VMSnapshotNics vMSnapshotNics;
    private volatile VMSnapshotDisks vMSnapshotDisks;
    private volatile VMSnapshotCdRoms vMSnapshotCdRoms;

    public VMSnapshot(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VMSnapshotNics getNics() {
        if (this.vMSnapshotNics == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.vMSnapshotNics == null) {
                    this.vMSnapshotNics = new VMSnapshotNics(this.proxy, this);
                }
            }
        }
        return this.vMSnapshotNics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VMSnapshotDisks getDisks() {
        if (this.vMSnapshotDisks == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.vMSnapshotDisks == null) {
                    this.vMSnapshotDisks = new VMSnapshotDisks(this.proxy, this);
                }
            }
        }
        return this.vMSnapshotDisks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VMSnapshotCdRoms getCdRoms() {
        if (this.vMSnapshotCdRoms == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.vMSnapshotCdRoms == null) {
                    this.vMSnapshotCdRoms = new VMSnapshotCdRoms(this.proxy, this);
                }
            }
        }
        return this.vMSnapshotCdRoms;
    }

    public Action restore(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/restore";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action restore(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/restore";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }
}

