/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.ClusterGlusterVolume;
import org.ovirt.engine.sdk.decorators.ClusterGlusterVolumeGlusterBrick;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.GlusterBrick;
import org.ovirt.engine.sdk.entities.GlusterBricks;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class ClusterGlusterVolumeGlusterBricks
extends CollectionDecorator<GlusterBrick, GlusterBricks, ClusterGlusterVolumeGlusterBrick> {
    private ClusterGlusterVolume parent;

    public ClusterGlusterVolumeGlusterBricks(HttpProxyBroker proxy, ClusterGlusterVolume parent) {
        super(proxy, "bricks");
        this.parent = parent;
    }

    @Override
    public List<ClusterGlusterVolumeGlusterBrick> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, GlusterBricks.class, ClusterGlusterVolumeGlusterBrick.class);
    }

    @Override
    public ClusterGlusterVolumeGlusterBrick get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, GlusterBrick.class, ClusterGlusterVolumeGlusterBrick.class);
    }

    public Action activate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + "activate";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action activate(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + "activate";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action stopmigrate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + "stopmigrate";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action stopmigrate(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + "stopmigrate";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action migrate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + "migrate";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action migrate(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + "migrate";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public List<ClusterGlusterVolumeGlusterBrick> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, GlusterBricks.class, ClusterGlusterVolumeGlusterBrick.class, headers);
    }

    public ClusterGlusterVolumeGlusterBrick add(GlusterBrick glusterbrick) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, glusterbrick, GlusterBrick.class, ClusterGlusterVolumeGlusterBrick.class, headers);
    }

    public ClusterGlusterVolumeGlusterBrick add(GlusterBrick glusterbrick, Boolean force) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (force != null) {
            urlBuilder.add("force", force, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().add(url, glusterbrick, GlusterBrick.class, ClusterGlusterVolumeGlusterBrick.class, headers);
    }

    public ClusterGlusterVolumeGlusterBrick add(GlusterBrick glusterbrick, Boolean force, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (force != null) {
            urlBuilder.add("force", force, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().add(url, glusterbrick, GlusterBrick.class, ClusterGlusterVolumeGlusterBrick.class, headers);
    }

    public ClusterGlusterVolumeGlusterBrick add(GlusterBrick glusterbrick, Boolean force, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (force != null) {
            urlBuilder.add("force", force, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().add(url, glusterbrick, GlusterBrick.class, ClusterGlusterVolumeGlusterBrick.class, headers);
    }
}

