/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenterNetwork;
import org.ovirt.engine.sdk.decorators.DataCenterNetworkPermission;
import org.ovirt.engine.sdk.entities.Permission;
import org.ovirt.engine.sdk.entities.Permissions;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class DataCenterNetworkPermissions
extends CollectionDecorator<Permission, Permissions, DataCenterNetworkPermission> {
    private DataCenterNetwork parent;

    public DataCenterNetworkPermissions(HttpProxyBroker proxy, DataCenterNetwork parent) {
        super(proxy, "permissions");
        this.parent = parent;
    }

    @Override
    public List<DataCenterNetworkPermission> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Permissions.class, DataCenterNetworkPermission.class);
    }

    @Override
    public DataCenterNetworkPermission get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Permission.class, DataCenterNetworkPermission.class);
    }

    public DataCenterNetworkPermission add(Permission permission) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, permission, Permission.class, DataCenterNetworkPermission.class, headers);
    }
}

