/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.web;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderUtils;
import org.ovirt.engine.sdk.utils.HttpResponseHelper;
import org.ovirt.engine.sdk.utils.StringUtils;
import org.ovirt.engine.sdk.web.ConnectionsPool;
import org.ovirt.engine.sdk.web.HttpDelete;

public class HttpProxy {
    private static final String SESSION_TTL_HEADER = "Session-TTL";
    private static final String COOKIE_HEADER = "Cookie";
    private static final String CONTENT_TYPE_HEADER = "Content-type";
    private static final String PERSISTENT_AUTH_HEADER_CONTENT = "persistent-auth";
    private static final String PERSISTENT_AUTH_HEADER = "Prefer";
    private static final String FILTER_HEADER = "Filter";
    private static final String[] STATIC_HEADERS = new String[]{"Content-type:application/xml"};
    private static final int BAD_REQUEST = 400;
    private ConnectionsPool pool;
    private List<Header> staticHeaders;
    private boolean persistentAuth = true;
    private boolean filter = false;
    private boolean debug = false;
    private String sessionid;

    public HttpProxy(ConnectionsPool pool, boolean persistent_auth, String sessionid, boolean filter, boolean debug) {
        this.pool = pool;
        this.staticHeaders = HttpHeaderUtils.toHeaders(STATIC_HEADERS);
        this.persistentAuth = persistent_auth;
        this.sessionid = sessionid;
        this.filter = filter;
        this.debug = debug;
    }

    public URL getUrl() {
        return this.pool.getUrl();
    }

    public String execute(HttpUriRequest request, List<Header> headers, Boolean last) throws IOException, ClientProtocolException, ServerException {
        this.injectHeaders(request, headers);
        HttpResponse response = this.pool.execute(request, (HttpContext)this.getContext());
        if (response.getStatusLine().getStatusCode() < 400) {
            return HttpResponseHelper.getEntity(response.getEntity());
        }
        throw new ServerException(response);
    }

    private BasicHttpContext getContext() {
        BasicHttpContext context = new BasicHttpContext();
        if (this.persistentAuth && StringUtils.isNulOrEmpty(this.sessionid)) {
            context.setAttribute("http.cookie-store", (Object)this.pool.getCookieStore());
        }
        return context;
    }

    private List<Header> excludeNullHeaders(List<Header> headers) {
        if (headers != null && !headers.isEmpty()) {
            ArrayList<Header> updated = new ArrayList<Header>();
            for (Header header : headers) {
                if (header.getValue() == null) continue;
                updated.add(header);
            }
            return updated;
        }
        return headers;
    }

    private void injectHeaders(HttpUriRequest request, List<Header> headers) {
        List<Header> updated = this.excludeNullHeaders(headers);
        if (updated != null && !updated.isEmpty()) {
            request.setHeaders(updated.toArray(new Header[updated.size()]));
        }
        for (Header header : this.staticHeaders) {
            if (header.getName().equals(CONTENT_TYPE_HEADER) && (request instanceof HttpDelete && ((HttpDelete)request).getEntity() == null || request instanceof HttpPut && ((HttpPut)request).getEntity() == null || request instanceof HttpPost && ((HttpPost)request).getEntity() == null)) continue;
            request.addHeader(header);
        }
        request.addHeader(FILTER_HEADER, Boolean.toString(this.isFilter()));
        if (this.persistentAuth) {
            request.addHeader(PERSISTENT_AUTH_HEADER, PERSISTENT_AUTH_HEADER_CONTENT);
            if (!StringUtils.isNulOrEmpty(this.sessionid)) {
                request.addHeader(COOKIE_HEADER, this.sessionid);
            }
            if (this.pool.getSessionTimeout() != null) {
                request.addHeader(SESSION_TTL_HEADER, String.valueOf(this.pool.getSessionTimeout()));
            }
        }
    }

    public boolean isPersistentAuth() {
        return this.persistentAuth;
    }

    public void setPersistentAuth(boolean persistentAuth) {
        this.persistentAuth = persistentAuth;
    }

    public void setSessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public boolean isSetSessionid() {
        return !StringUtils.isNulOrEmpty(this.sessionid);
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void shutdown() {
        this.pool.shutdown();
    }
}

