/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenter;
import org.ovirt.engine.sdk.decorators.DataCenterIscsiBond;
import org.ovirt.engine.sdk.entities.IscsiBond;
import org.ovirt.engine.sdk.entities.IscsiBonds;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class DataCenterIscsiBonds
extends CollectionDecorator<IscsiBond, IscsiBonds, DataCenterIscsiBond> {
    private DataCenter parent;

    public DataCenterIscsiBonds(HttpProxyBroker proxy, DataCenter parent) {
        super(proxy, "iscsibonds");
        this.parent = parent;
    }

    @Override
    public List<DataCenterIscsiBond> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, IscsiBonds.class, DataCenterIscsiBond.class);
    }

    @Override
    public DataCenterIscsiBond get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, IscsiBond.class, DataCenterIscsiBond.class);
    }

    @Override
    public DataCenterIscsiBond getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, IscsiBond.class, DataCenterIscsiBond.class);
    }

    public DataCenterIscsiBond add(IscsiBond iscsibond) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, iscsibond, IscsiBond.class, DataCenterIscsiBond.class, headers);
    }

    public DataCenterIscsiBond add(IscsiBond iscsibond, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, iscsibond, IscsiBond.class, DataCenterIscsiBond.class, headers);
    }
}

