/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.VM;
import org.ovirt.engine.sdk.decorators.VMSession;
import org.ovirt.engine.sdk.entities.Session;
import org.ovirt.engine.sdk.entities.Sessions;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class VMSessions
extends CollectionDecorator<Session, Sessions, VMSession> {
    private VM parent;

    public VMSessions(HttpProxyBroker proxy, VM parent) {
        super(proxy, "sessions");
        this.parent = parent;
    }

    @Override
    public List<VMSession> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Sessions.class, VMSession.class);
    }

    @Override
    public VMSession get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Session.class, VMSession.class);
    }

    @Override
    public VMSession getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Session.class, VMSession.class);
    }
}

