/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenterIscsiBond;
import org.ovirt.engine.sdk.decorators.DataCenterIscsiBondStorageConnection;
import org.ovirt.engine.sdk.entities.StorageConnection;
import org.ovirt.engine.sdk.entities.StorageConnections;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class DataCenterIscsiBondStorageConnections
extends CollectionDecorator<StorageConnection, StorageConnections, DataCenterIscsiBondStorageConnection> {
    private DataCenterIscsiBond parent;

    public DataCenterIscsiBondStorageConnections(HttpProxyBroker proxy, DataCenterIscsiBond parent) {
        super(proxy, "storageconnections");
        this.parent = parent;
    }

    @Override
    public List<DataCenterIscsiBondStorageConnection> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, StorageConnections.class, DataCenterIscsiBondStorageConnection.class);
    }

    @Override
    public DataCenterIscsiBondStorageConnection get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, StorageConnection.class, DataCenterIscsiBondStorageConnection.class);
    }

    @Override
    public DataCenterIscsiBondStorageConnection getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, StorageConnection.class, DataCenterIscsiBondStorageConnection.class);
    }

    public DataCenterIscsiBondStorageConnection add(StorageConnection storageconnection) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, storageconnection, StorageConnection.class, DataCenterIscsiBondStorageConnection.class, headers);
    }
}

